/*
 * Decompiled with CFR 0.152.
 */
package graphx;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

class MyDisplay
extends Panel {
    Image image;
    BufferedImage logo;
    Font messagefont;
    String message;
    int messageCount;
    int boxCount;
    int logoCount;

    public MyDisplay(String message, int messageCount, int boxCount, int logoCount) {
        this.message = message;
        this.messageCount = messageCount;
        this.boxCount = boxCount;
        this.logoCount = logoCount;
        this.createImage();
        this.addMouseListener(new CustomMouseListener());
        this.addComponentListener(new CustomComponentListener());
        InputStream rsc = MyDisplay.class.getResourceAsStream("fonts/CabinSketch-Bold.ttf");
        try {
            this.messagefont = Font.createFont(0, rsc);
        }
        catch (FontFormatException | IOException e) {
            this.messagefont = new Font("Times New Roman", 1, 1);
        }
        rsc = MyDisplay.class.getResourceAsStream("img/Tux.png");
        try {
            this.logo = ImageIO.read(rsc);
            System.out.println(this.logo.getWidth() + "x" + this.logo.getHeight());
        }
        catch (IOException e) {
            this.logo = new BufferedImage(1, 1, 1);
            System.err.println("Image load fail");
        }
    }

    public void updateImage() {
        this.createImage();
        this.repaint();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        g.drawImage(this.image, 0, 0, this);
    }

    private void createImage() {
        int i;
        int width = this.getWidth();
        int height = this.getHeight();
        if (width <= 0 || height <= 0) {
            return;
        }
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D ig2 = bi.createGraphics();
        ig2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        ig2.setBackground(new Color((int)(Math.random() * 64.0), (int)(Math.random() * 96.0), (int)(Math.random() * 128.0)));
        ig2.clearRect(width / 8, 40, width * 3 / 4, height - 80);
        for (i = 0; i < this.boxCount; ++i) {
            ig2.setPaint(new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0), 64));
            ig2.fillRoundRect((int)(Math.random() * (double)(width - 150)), (int)(Math.random() * (double)(height - 90)), 50 + (int)(Math.random() * 100.0), 30 + (int)(Math.random() * 60.0), 10, 10);
        }
        for (i = 0; i < this.logoCount; ++i) {
            double scale = Math.random() * 0.45 + 0.05;
            int w = (int)((double)this.logo.getWidth() * scale);
            int h = (int)((double)this.logo.getHeight() * scale);
            ig2.drawImage(this.logo, (int)(Math.random() * (double)(width - w)), (int)(Math.random() * (double)(height - h)), w, h, null);
        }
        for (i = 0; i < this.messageCount; ++i) {
            ig2.setPaint(new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0), 255));
            Font font = this.messagefont.deriveFont(1, 20 + (int)(Math.random() * 80.0));
            ig2.setFont(font);
            FontMetrics fontMetrics = ig2.getFontMetrics(font);
            int stringWidth = fontMetrics.stringWidth(this.message);
            int stringHeight = fontMetrics.getAscent();
            ig2.drawString(this.message, (int)(Math.random() * (double)(width - stringWidth)), (int)(Math.random() * (double)(height - stringHeight) + (double)stringHeight));
        }
        this.image = bi;
    }

    class CustomComponentListener
    implements ComponentListener {
        CustomComponentListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            MyDisplay.this.updateImage();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }
    }

    class CustomMouseListener
    implements MouseListener {
        CustomMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Point p = e.getPoint();
            MyDisplay.this.updateImage();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

