/*
 * Decompiled with CFR 0.152.
 */
package graphx;

import graphx.MyDisplay;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Timer;
import java.util.TimerTask;

public class Graphix {
    private MyDisplay md;
    private Frame f;
    private final int WIDTH = 800;
    private final int HEIGHT = 600;
    private Timer timer;

    public Graphix(String message, int messageCount, int boxCount, int logoCount, int delay) {
        this.md = new MyDisplay(message, messageCount, boxCount, logoCount);
        this.f = new Frame("MyGraphix");
        this.f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.f.setSize(800, 600);
        this.f.add(this.md);
        this.f.setVisible(true);
        this.timer = new Timer("timer", false);
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Graphix.this.md.updateImage();
            }
        }, delay, (long)delay);
    }

    public static void main(String[] args) {
        String message = "Java";
        int messageCount = 15;
        int boxCount = 20;
        int logoCount = 10;
        int delay = 5000;
        if (args.length > 0) {
            message = args[0];
        }
        if (System.getProperty("messagecount") != null) {
            System.err.println("Found messagecount");
            messageCount = Integer.parseInt(System.getProperty("messagecount"));
        }
        if (System.getProperty("boxcount") != null) {
            System.err.println("Found boxcount");
            boxCount = Integer.parseInt(System.getProperty("boxcount"));
        }
        if (System.getProperty("logocount") != null) {
            System.err.println("Found delay");
            delay = Integer.parseInt(System.getProperty("logocount"));
        }
        if (System.getProperty("delay") != null) {
            System.err.println("Found delay");
            delay = Integer.parseInt(System.getProperty("delay"));
        }
        Graphix g = new Graphix(message, messageCount, boxCount, logoCount, delay);
    }
}

